<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Photo;

class UserController extends Controller
{
    /**
     * Show the About page.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function about()
    {
        return view('about');
    }
    /**
     * Show the Services page.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function services()
    {
        return view('services');
    }
    /**
     * Show the Portfolio page.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function portfolio()
    {
        $table  = Photo::latest()->where('type', 0)->paginate(5);
        $people = Photo::latest()->where('type', 1)->paginate(5);
        $couple = Photo::latest()->where('type', 2)->paginate(5);

        return view('portfolio', compact('table', 'people', 'couple'));
    }
    /**
     * Show the Team page.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function team()
    {
        return view('team');
    }
    /**
     * Show the Pakacha page.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function pakacha()
    {
        return view('pakacha');
    }
    /**
     * Show the contacts page.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function contacts()
    {
        return view('contacts');
    }

    public function farmTour() {
        return view('farmTour');
    }

    public function cookingClass() {
        return view('cookingClass');
    }

    
}
