<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Photo;
use Carbon\Carbon;

class UploadImagesController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */

    public function __construct() {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $images = Photo::latest()->paginate(10);

        return view('gallery.index', compact('images'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('gallery.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $request->validate([
            'type' => 'required',
            'images' => 'required',
            'images.*' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:6144',
        ]);
      
        if($request->hasfile('images')) 
        {
            foreach($request->file('images') as $key => $file)
            {
                $name = $file->getClientOriginalName();
                $path = $file->move('image-gallery', $name);
                $type = $request->get('type');
                $created_at = Carbon::now()->toDateTimeString();  

                $insert[$key]['name'] = $name;
                $insert[$key]['path'] = $path;
                $insert[$key]['type'] = $type;
                $insert[$key]['created_at'] = $created_at;

            }
        }
        Photo::insert($insert);
      
        return back()
                ->with('success','You have successfully uploaded images.');

    }    

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $image = Photo::find($id);

        return view('gallery.show', compact('image')); 

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $images = Photo::find($id);
        $images->delete();

        return redirect()->route('gallery.index')
                         ->with('success','Image deleted successfully');
    }
}
