@extends('layouts.app')

@section('content')

  <!-- ======= Header ======= -->
  <header id="header" class="fixed-top d-flex align-items-center ">
    <div class="container d-flex justify-content-between align-items-center">

      <div class="logo">
        <!-- <h1 class="text-light"><a href="index.html"><span>Moderna</span></a></h1> -->
        <!-- Uncomment below if you prefer to use an image logo -->
        <a href="{{ ('/') }}"><img src="img/logo.png" alt="" class="img-fluid"></a>
      </div>

      @include('layouts.nav')

    </div>
  </header><!-- End Header -->

  <main id="main">

    <!-- ======= Our Portfolio Section ======= -->
    <section class="breadcrumbs">
      <div class="container">

        <div class="d-flex justify-content-between align-items-center">
          <h2>Photos of the Week</h2>
          <ol>
            <li><a href="{{ ('/') }}">Home</a></li>
            <li>Gallery</li>
          </ol>
        </div>

      </div>
    </section><!-- End Our Portfolio Section -->

    <!-- ======= Portfolio Section ======= -->
    <section class="portfolio">
      <div class="container">

        <div class="row">
          <div class="col-lg-12">
            <ul id="portfolio-flters">
              <li data-filter="*" class="filter-active">All</li>
              <li data-filter=".filter-app">The Table</li>
              <li data-filter=".filter-card">People 🕺💃 </li>
            </ul>
          </div>
        </div>

        <div class="row portfolio-container" data-aos="fade-up" data-aos-easing="ease-in-out" data-aos-duration="500">
        @foreach ($table as $image)
          <div class="col-lg-4 col-md-6 portfolio-wrap filter-app">
            <div class="portfolio-item">
              <img src="{{ asset($image->path) }}" class="img-fluid" alt="">
              <div class="portfolio-info">
                <h3>
                    @if ( $image->type  == 0)
                        The Table
                    @else ( $image->type == 1)
                         People 🕺💃
                    @endif
                </h3>
                <div>
                  <a href="{{ asset($image->path) }}" data-gallery="portfolioGallery" class="portfolio-lightbox" title="@if ( $image->type  == 0)
                        The 🍛 Table
                    @elseif ( $image->type == 1)
                        💃 People 🕺
                    @else
                        Beautiful ❤️ Couples
                    @endif"><i class="bx bx-plus"></i></a>
                </div>
              </div>
            </div>
          </div>
        @endforeach

        @foreach ($people as $image)
          <div class="col-lg-4 col-md-6 portfolio-wrap filter-card">
            <div class="portfolio-item">
              <img src="{{ asset($image->path) }}" class="img-fluid" alt="">
              <div class="portfolio-info">
                <h3>
                    @if ( $image->type  == 0)
                        The 🍛 Table
                    @elseif ( $image->type == 1)
                        💃 People 🕺
                    @else
                        Beautiful ❤️ Couples
                    @endif
                </h3>
                <div>
                  <a href="{{ asset($image->path) }}" data-gallery="portfolioGallery" class="portfolio-lightbox" title="@if ( $image->type  == 0)
                        The 🍛 Table
                    @elseif ( $image->type == 1)
                        💃 People 🕺
                    @else
                        Beautiful ❤️ Couples
                    @endif"><i class="bx bx-plus"></i></a>
                </div>
              </div>
            </div>
          </div>
        @endforeach

        @foreach ($couple as $image) 
          <div class="col-lg-4 col-md-6 portfolio-wrap filter-web">
            <div class="portfolio-item">
              <img src="{{ asset($image->path) }}" class="img-fluid" alt="">
              <div class="portfolio-info">
                <h3>
                    @if ( $image->type  == 0)
                        The 🍛 Table
                    @elseif ( $image->type == 1)
                        💃 People 🕺
                    @else
                        Beautiful ❤️ Couples
                    @endif
                </h3>
                <div>
                  <a href="{{ asset($image->path) }}" data-gallery="portfolioGallery" class="portfolio-lightbox" title="@if ( $image->type  == 0)
                        The 🍛 Table
                    @elseif ( $image->type == 1)
                        💃 People 🕺
                    @else
                        Beautiful ❤️ Couples
                    @endif"><i class="bx bx-plus"></i></a>
                </div>
              </div>
            </div>
          </div>
        @endforeach          
        </div>

      </div>
    </section><!-- End Portfolio Section -->

  </main><!-- End #main -->

  <!-- ======= Footer ======= -->

  @include('layouts.footer')

  <!-- End Footer -->



@endsection
